# Malware Analysis - WannaCry and the Elastic Stack

This example provides supporting files for the blog post ["Detecting Signs of Ramsomware: WannaCry and the Elastic Stack"](http://elastic.co/blog/malware-analysis-wannacry-elastic-stack).

In addition to the relevant configurations so users can recreate the environment, a snapshot of the Elasticsearch index used for analysis of the WannaCry malware is provided with instructions for restoration.

## Contents

This example includes:

* Packetbeat configuration for reference
* Winlogbeat configuration for reference
* Sysmon configuration for reference. This configuration has been adapted from the SwiftOnSecurity example provided [here](https://github.com/SwiftOnSecurity/sysmon-config)
* Snapshot of the Elasticsearch index captured during analyis. Instructions for restoration.

## Environment and Analysis

The following environment was created for purposes of detonating the WannaCry malware:

* 2 x Windows 7 SP1 VMs - `windows_1` and `windows_2`. Unpatched against the MS17-010 SMB vulnerability.
* 1 x Windows 2012 R2 VM - `windows_server_2012`.  Unpatched against the MS17-010 SMB vulnerability. Domain Controller, DNS, DHCP, Webserver and SMB share manager.
* 1 x Ubuntu 16.04 VM hosting Elasticsearch 5.4 and malware sample on webserver.

The above VM's were hosted using VirtualBox on an OSX Host. Instances had no external connectivity - [Internal Network](https://www.virtualbox.org/manual/ch06.html#network_internal) only.
Packetbeat, Sysmon and Winlogbeat were installed on all Windows images. Configurations have been provided.

If recreating the environment consider changing:

* Packebeat.yml - ES host and port used in the section `output.elasticsearch`
* Winlogbeat.yml - ES host and port used in the section `output.elasticsearch`
* Sysmonconfig.xml - Suggestions and additions for deeper analysis welcome.

Obtaining a copy of the WannaCry malware is left to the user. Any attempt by the user to reproduce the environment and results is at their own risk.

## Restoring and Exploring the data

### Pre-requisites

* Elasticsearch 6.2 or above
* Kibana 6.2 or above

### Installation Steps

* Follow the [Installation & Setup Guide](https://github.com/elastic/examples/blob/master/Installation%20and%20Setup.md) to install and test the Elastic Stack (*you can skip this step if you have a working installation of the Elastic Stack,*)

* Run Elasticsearch & Kibana

  ```shell
    <path_to_elasticsearch_root_dir>/bin/elasticsearch
    <path_to_kibana_root_dir>/bin/kibana

  ```
* Check that Elasticsearch and Kibana are up and running.

  - Open `localhost:9200` in web browser -- should return a json message indicating ES is running.
  - Open `localhost:5601` in web browser -- should display Kibana UI.

  **Note:** By default, Elasticsearch runs on port 9200, and Kibana run on ports 5601. If you changed the default ports, change the above calls to use the appropriate ports.  

### Restoring the Snapshot

In order to restore the data captured during the writing of the above blog an Elasticsearch [snapshot](https://www.elastic.co/guide/en/elasticsearch/reference/current/modules-snapshots.html) is provided.  This contains all of the signatures discussed.

Perform the following steps:

1. Download and uncompress the index snapshot .tar.gz file into a local folder from [here](http://download.elasticsearch.org/demos/wanna_cry/snapshot_wanna_cry.tar.gz)
  
      ```shell
      # Create snapshots directory
      mkdir ./elastic_wanna_cry
      cd elastic_wanna_cry
      # Download index snapshot to your new snapshots directory
      curl -O http://download.elasticsearch.org/demos/wanna_cry/snapshot_wanna_cry.tar.gz
      # Uncompress snapshot file (uncompressed to wanna_cry subfolder)
      tar -xzf snapshot_wanna_cry.tar.gz
      ```
1. Add the location of the uncompressed snapshot dir to `path.repo` variable in the `elasticsearch.yml` in the `path_to_elasticsearch_root_dir/config/` folder. See example [here](https://www.elastic.co/guide/en/elasticsearch/reference/current/modules-snapshots.html#_shared_file_system_repository). You will need to restart Elasticsearch for the settings to take effect. Your config should look something like: 
```console
path.repo: ["/path/to/folder/elastic_wanna_cry/wanna_cry"]
```

1. Register a file system repository for the snapshot *(change the value of the “location” parameter below to the location of your uncompressed snapshot directory)*
      ```shell
      curl -H "Content-Type: application/json" -XPUT 'http://localhost:9200/_snapshot/wanna_cry' -d '{
          "type": "fs",
          "settings": {
              "location": "<path_to_uncompressed_folder>",
              "compress": true,
              "max_snapshot_bytes_per_sec": "1000mb",
              "max_restore_bytes_per_sec": "1000mb"
          }
      }'
      ```

Which should result in

```console
{"acknowledged":true}
```

1. Restore the index data into your Elasticsearch instance:

    ```shell
    curl -XPOST "localhost:9200/_snapshot/wanna_cry/snapshot-wanna-cry/_restore"
    ```
Which should result in

```console
{"accepted":true}
```

This restoration should take a few seconds. Confirm the index is ready with the following commands:

* `curl http://localhost:9200/packetbeat*/_count` This should return a count of 20524 i.e. `{"count":20524,"_shards":{"total":10,"successful":10,"failed":0}}`
* `curl http://localhost:9200/winlogbeat*/_count` This should return a count of 8328 i.e. `{"count":8328,"_shards":{"total":10,"successful":10,"failed":0}}`

### Exploring the data

* Access Kibana by going to `http://localhost:5601` in a web browser
* Connect Kibana to the `packetbeat-*` and `winlogbeat-*` indices in Elasticsearch
    * Click the **Management** tab >> **Index Patterns** tab >> **Create New**. Specify `packetbeat-*` as the index pattern name and click **Create** to define the index pattern. (Leave the **Index contains time-based events** box checked and use @timestamp as the Time Field). Leave all other boxes unchecked.
    * Repeat the above steps for the patterns `winlogbeat-*` and `*` (to allow search across all indices).
* Open discover
    * Click on **Discover** tab 
* Navigate to the time period in which testing was performed. Select time selector in the upper right. Select the option **Absolute** and enter the values `2017-05-26 00:00:00.000` and `2017-05-26 23:59:59.999` for the From and To fields respectively.
* Zoom in on the captured data by drawing a rectangle around bars you see
* Explore the data!

## Sequence of tests


As shown below and as described in the blog post, the following tests were performed in order:

1. WannaCry downloaded from Ubuntu 16.04 sample to windows_1 VM
1. WannaCry executed and propagation amongst Windows VMs monitored
1. Windows VMs reset to snapshot prior to previous exeuction. Kill Switch domains added to windows_server_2012 and malware re-detonated. 

![Discover View of WannaCry Tests](images/kibana.png?raw=true)



